clear
% close all
clc

VD = [-0.1, -1.1];        % vector of V_DS voltages for the plot
myIDVG = [  'Sentaurus/IDVG_sat_jlnt_pmos_des.plt';
            'Sentaurus/IDVG_lin_jlnt_pmos_des.plt'];

myColor = 'blue';

figure(1)
grid on
hold on
box on
xlabel('Gate-source voltage V_{GS}, V')
ylabel('Drain current I_D, uA')
xlim([-1.6, 0.5])
% ylim([-1e-5,-1e-16])
xQuantity = 'GateOuterVoltage';
yQuantity = 'DrainTotalCurrent';

figure(2)
grid on
hold on
box on
xlabel('Gate-source voltage V_{GS}, V')
ylabel('Drain current I_D, A')
xlim([-1.6, 0.5])
set(gca,'YScale','log')
set(gca,'YDir','reverse')
xQuantity = 'GateOuterVoltage';
yQuantity = 'DrainTotalCurrent';

for i = 1:length(VD)
    fileName = myIDVG(i,:);
    [data,vars] = f_plt2var(fileName);
    
    flgCmp = 0;
    indCmp = 0;
    while(flgCmp == 0)
        indCmp = indCmp + 1;
        flgCmp = strcmp(xQuantity,vars{indCmp}{1});
    end
    j = indCmp;
    flgCmp = 0;
    indCmp = 0;
    while(flgCmp == 0)
        indCmp = indCmp + 1;
        flgCmp = strcmp(yQuantity,vars{indCmp}{1});
    end
    k = indCmp;
    
    V_G = data(j,:);
    I_D = data(k,:);
    ID(i,:) = I_D;
    VG(i,:) = V_G;
    
    % Linear plot in uA
    figure(1)
    plot(V_G,I_D*1e6,myColor,'LineWidth',1.5)

    % Logarithmic plot in A
    figure(2)
    plot(V_G,I_D,myColor,'LineWidth',1.5)
    
end
legStr = ["Measurement","Measurement","Sentaurus","Sentaurus"];
neworder = [1, 3];

% legStr = ["Measurement","Measurement","Single level", "lol", "Gaussian"];
% neworder = [1, 3, 5];

figure(1)
lha = legend(legStr,'Location','SouthEast');
lha.AutoUpdate = 'off';
lha.PlotChildren = lha.PlotChildren(neworder);
% set(gca,'FontSize',14,'FontName','Times New Roman')

figure(2)
lhb = legend(legStr,'Location','SouthWest');
lhb.AutoUpdate = 'off';
lhb.PlotChildren = lhb.PlotChildren(neworder);
% set(gca,'FontSize',14,'FontName','Times New Roman')

% Subthreshold analysis - Saturation regime
% USE 1e-8 FOR 20 AND 27 nm DEVICES
% USE 1e-7 FOR 34 nm DEVICE (it doesn't get to 1e-8 A)
SubThRegionEnd = 1e-8;      % [A]
indSubTh = find(abs(ID(1,:)) < SubThRegionEnd);
VG_SubTh = VG(1,indSubTh);
Vth_sat =  VG_SubTh(length(VG_SubTh));
fprintf("Saturation:\n");
fprintf("Vth = %.3f V\n\n", Vth_sat);

% Subthreshold analysis - Linear regime
indSubTh = find(abs(ID(2,:)) < SubThRegionEnd);
VG_SubTh = VG(2,indSubTh);
ID_SubTh = abs(ID(2,indSubTh));
Vth_lin =  VG_SubTh(length(VG_SubTh));
% Compute subthreshold slope
c = abs(polyfit(VG_SubTh,log10(ID_SubTh),1));
S_numerical = 1/c(1)*1000;   % mV/dec
fprintf("Linear:\n");
fprintf("Vth = %.3f V\n\n", Vth_lin);
fprintf("SS = %.3f mV/dec\n\n", S_numerical);

% DIBL = (Threshold Voltage DIBL - Threshold Voltage) / VDS
DIBL = abs(Vth_sat - Vth_lin);
fprintf("DIBL = %.3f \n", DIBL);
